﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class IngredientsCabinetController : MonoBehaviour
{
    public static IngredientsCabinetController instance;

    protected bool silenced;
    protected bool isActive = false;
    protected GameObject panel;
    protected GameObject selector;
    protected Transform options;
    protected AudioSource audioSource;

    protected int selectedOption;
    protected HashSet<string> selectedIngredients = new HashSet<string>();

    private void OnEnable()
    {
        instance = this;
        audioSource = GetComponent<AudioSource>();
        panel = transform.GetChild(0).gameObject;
        selector = panel.transform.GetChild(0).gameObject;
        options = panel.transform.GetChild(1);
    }

    public void Activate()
    {
        isActive = true;
        silenced = false;

        panel.SetActive(true);
        SelectOption(0);

        audioSource.volume = .5f;
        audioSource.Play();
    }

    public void Deactivate()
    {
        isActive = false;
        panel.SetActive(false);
        silenced = true;
    }

    protected void SelectOption(int option)
    {
        selectedOption = option;
        Transform optionTransform = options.GetChild(selectedOption);
        selector.transform.position = new Vector3(selector.transform.position.x, optionTransform.position.y, selector.transform.position.z);
    }

    protected void ToggleCurrentSelected()
    {
        Transform option = options.GetChild(selectedOption);
        Text optionNameText = option.GetChild(0).GetComponent<Text>();

        if (optionNameText.text == "Back")
        {
            if (selectedIngredients.Count == 3
                && selectedIngredients.Contains("Flour")
                && selectedIngredients.Contains("Salt")
                && selectedIngredients.Contains("Yeast"))
            {
                GameController.instance.RemoveFlag("Bad Dough Ingredients");
                GameController.instance.RemoveFlag("True Dough Ingredients");
                GameController.instance.AddFlag("Dough Ingredients");
            }
            else if (selectedIngredients.Count == 6
                && selectedIngredients.Contains("Flour")
                && selectedIngredients.Contains("Salt")
                && selectedIngredients.Contains("Sugar")
                && selectedIngredients.Contains("Milk")
                && selectedIngredients.Contains("Butter")
                && selectedIngredients.Contains("Yeast"))
            {
                GameController.instance.RemoveFlag("Bad Dough Ingredients");
                GameController.instance.RemoveFlag("Dough Ingredients");
                GameController.instance.AddFlag("True Dough Ingredients");
            }
            else
            {
                GameController.instance.RemoveFlag("Dough Ingredients");
                GameController.instance.RemoveFlag("True Dough Ingredients");
                GameController.instance.AddFlag("Bad Dough Ingredients");
            }

            GameController.instance.StopCabinetMinigame();
            return;
        }

        Text optionValueText = option.GetChild(1).GetComponent<Text>();

        if (selectedIngredients.Contains(optionNameText.text))
        {
            selectedIngredients.Remove(optionNameText.text);
            optionValueText.text = "In Cabinet";
            optionValueText.color = Color.white;
        }
        else
        {
            selectedIngredients.Add(optionNameText.text);
            optionValueText.text = "In Pockets";
            optionValueText.color = Color.blue;
        }
    }

    // Update is called once per frame
    void Update()
    {
        if (silenced)
        {
            audioSource.volume = Mathf.Lerp(audioSource.volume, 0f, 0.05f);
        }

        if (!isActive)
        {
            return;
        }

        if (Input.GetButtonDown("Up"))
        {
            SelectOption((selectedOption + options.childCount - 1) % options.childCount);
        }

        if (Input.GetButtonDown("Down"))
        {
            SelectOption(selectedOption = (selectedOption + 1) % options.childCount);
        }

        if (Input.GetButtonDown("Interact"))
        {
            ToggleCurrentSelected();
        }
    }
}
